.comment
;---------------------------------------
;- Load Error / Lethargy
;- 256 byte intro

;- Code by Visage
;- Logo by Grass

;- 2017.12.16 - 2018.04.30
;- Assembler compiler: 64tass Turbo Assembler Macro V1.53.1515
;---------------------------------------
.endc

*= $0801
.byte $0b,$08,$e2,$07,$9e,$32,$30,$35,$39,$00	;BASIC line
;---------------------------------------
*=$080b
Main
	ldy #$00

TheLoop

;SCREEN MEMORY SPLIT
		lda #$48
-		cmp $d012		; wait till the top rasterline reached
		bne -

		lda #$85		; switch to screen at $2000
		sta $d018

		lda #$e2
-		cmp $d012		; wait till the bottom rasterline reached
		bne -

		lda #$15		; switch to default screen at $0400
		sta $d018

;SCREEN RANDOMIZE
		ldx #$02		; in case if needed
sr		lda #$fd
-		lda $dc04
		sta $2000+40*3-2,x
		sta $2100+40*3-4,x
		sta $2200+40*3-6,x
		inx
		bne -			; filling up the middle memory area, every cycle
		inc sr+1		; new character, every cycle

		cpx ww+1		; checking if we are in the final of the intro (X is always #$00 here)
		bne +
		inc lc+1		; in the final, let's cycle the logo characters too...
+
		sty SaveY+1		; saving Y, we need it later

;SOUND
		ldy #$0f
		sty $d418		; volume max

		sta $d400		; freq -> accuomlator is the "randomized" background character
		sta $d401		; freq

		lda #$81		;#%10000001
		sta $d404		; voice control register
		lda #$88
		sta $d405		; AD
		sta $d406		; SR

;LOGO DRAW
-		ldy LogoData,x
		lda #$a0				; draw the logo by duplicated pixels, first is always invert space
la		sta $2000+9*40+12,y
		clc
lc		adc #$80				; 1. invert every second pixel - 2. later randomize the shadow
lb		sta $2001+9*40+12,y
		inx
ld		cpx #1 ;logo size is #35 bytes
		bne -

;LOOPING
SaveY	ldy #$00
		iny
		cpy #$20
		beq +					;"bne TheLoop" -> this JMP helps out in the long brunch!
TheLoopJ jmp TheLoop			; Looping the flickering for a while
+		sty $d418			; Silence (Y=#$20)

;PAUSE
ww	ldy #20 ; configuring the waiting time
-	ldx #$df	; this is also the counter for the final looping
	lda #$FF
-	cmp $d012
	bne -		; waiting for a screen refresh
	inx
	bne -
	cpy #$00	; if reached the "fastest speed"
	beq +		; then simple looping some more and do the logo shadow moving effect
	dey
	bne --
	
	inc ld+1
	inc ld+1	; show the next pixels of the logo
	inc ww+3
	dec ww+1	; configure the waiting time, so speeding up a little bit... ;) 
	bne TheLoopJ	; let's do another round, but faster this time

+	lda #41		; moving the logo shadow down a line and one char left...
	clc
	adc lb+1	
	sta lb+1
	cmp #40
	bcs +
	inc lb+2
+	
	inc ww+3	; coounting the final looping
	bne TheLoopJ

; Display "KEEP DREAMING." in black
	ldy #16
-	lda txt,y		; load next char and send to the keyboard buffer
	sta $277,y
	inc $c6				; increment the buffer: indicate there's a new char arrived :)
	dey
	bne -
		
	jmp $e19c	; load error call, end of this intro

;LOGO: 16x7 pixel max!
LogoData	.byte 0
			.byte 40,80
			.byte 120,160
			.byte 200,240
			.byte 242,244
			.byte 204,43
			.byte 3,5
			.byte 7,47
			.byte 87,127
			.byte 167,207
			.byte 247,250
			.byte 210,170
			.byte 130,90
			.byte 50,10
			.byte 132,134
			.byte 94,174
			.byte 54,214
			.byte 14,254
			.byte 254,254,254,254,254
txt			.byte 254		;the last char of the logo data is used to point to the text properly
			.text $8d,"keep dreaming.",$00	; Shoft+Return -> keep dreaming. -> in black color
.end
